%--------------------------------------------------------------------------
% File     : LCL109=CAM_MV4-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Many valued sentential)
% Problem  : MV-4 depends on the Merideth system
% Version  : 
% English  : An axiomatisation of the many valued sentential calculus 
%            is {MV-1,MV-2,MV-3,MV-5} by Meredith. Show that MV-4 depends 
%            on the Meredith system.

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : MV-55 [McCune & Wos, 1992]
%          : Luka5 [ANL]

% Status   : 
% Syntax   : Number of clauses           :    6 (   0 non-Horn)(   5 unit)
%            Number of literals          :    8 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   11 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(mv_1,axiom,
    [++is_a_theorem(implies(X,implies(Y,X)))]).

input_clause(mv_2,axiom,
    [++is_a_theorem(implies(implies(X,Y),implies(implies(Y,Z),
implies(X,Z))))]).

input_clause(mv_3,axiom,
    [++is_a_theorem(implies(implies(implies(X,Y),Y),
implies(implies(Y,X),X)))]).

input_clause(mv_5,axiom,
    [++is_a_theorem(implies(implies(not(X),not(Y)),implies(Y,X)))]).

input_clause(prove_mv_4,theorem,
    [--is_a_theorem(implies(implies(implies(a,b),implies(b,a)),
implies(b,a)))]).
%--------------------------------------------------------------------------
