%--------------------------------------------------------------------------
% File     : LCL108=McAx_Q3-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Left group)
% Problem  : Q-3 depends on the single McCune axiom
% Version  : 
% English  : Axiomatisations of the left group calculus are {LG-1, 
%            LG-2,LG-3,LG-4,LG-5} by Kalman, {LG-2,LG-3}, {LG-2,P-1}, 
%            {LG-2,P-4}, {LG-2,Q-1,Q-2}, {P-1,Q-3}, {P-4,Q-3}, {Q-1, 
%            Q-2,Q-3}, {Q-1,Q-3,Q-4}, {LG-27-1690} all by McCune. Show 
%            that Q-3 depends on the single McCune axiom.

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Automated Discovery of New 
%            Axiomatisations of the Left Group and Right Group Calculi, 
%            In Journal of Automated Reasoning 9(1), Kluwer Academic 
%            Publishers, Dordrecht, The Netherlands, 1-24.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : LG-101 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   2 unit)
%            Number of literals          :    5 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :    9 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    7

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(lg_27_1690,axiom,
    [++is_a_theorem(equivalent(equivalent(equivalent(
equivalent(X,Y),Z),equivalent(equivalent(U,V),equivalent(equivalent(
equivalent(W,V),equivalent(W,U)),V6))),equivalent(Z,equivalent(
equivalent(Y,X),V6))))]).

input_clause(prove_q_3,theorem,
    [--is_a_theorem(equivalent(equivalent(equivalent(a,b),equivalent(
equivalent(b,a),c)),c))]).
%--------------------------------------------------------------------------
