%--------------------------------------------------------------------------
% File     : LCL105=Mc7_LG2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Left group)
% Problem  : LG-2 depends on the 7th McCune system
% Version  : 
% English  : Axiomatisations of the left group calculus are {LG-1, 
%            LG-2,LG-3,LG-4,LG-5} by Kalman, {LG-2,LG-3}, {LG-2,P-1}, 
%            {LG-2,P-4}, {LG-2,Q-1,Q-2}, {P-1,Q-3}, {P-4,Q-3}, {Q-1, 
%            Q-2,Q-3}, {Q-1,Q-3,Q-4}, {LG-27-1690} all by McCune. Show 
%            that LG-2 depends on the seventh McCune system.

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Automated Discovery of New 
%            Axiomatisations of the Left Group and Right Group Calculi, 
%            In Journal of Automated Reasoning 9(1), Kluwer Academic 
%            Publishers, Dordrecht, The Netherlands, 1-24.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : LG-98 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    5 (   0 non-Horn)(   4 unit)
%            Number of literals          :    7 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   4 constant)
%            Number of variables         :   11 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(q_1,axiom,
    [++is_a_theorem(equivalent(X,equivalent(equivalent(Y,Z),
equivalent(equivalent(Z,Y),X))))]).

input_clause(q_2,axiom,
    [++is_a_theorem(equivalent(equivalent(X,Y),equivalent(
equivalent(Z,X),equivalent(Z,Y))))]).

input_clause(q_3,axiom,
    [++is_a_theorem(equivalent(equivalent(equivalent(X,Y),
equivalent(equivalent(Y,X),Z)),Z))]).

input_clause(prove_lg_2,theorem,
    [--is_a_theorem(equivalent(equivalent(equivalent(equivalent(
equivalent(a,b),equivalent(a,c)),equivalent(b,c)),e),e))]).
%--------------------------------------------------------------------------
