%--------------------------------------------------------------------------
% File     : LCL097=Kl_LG4-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Left group)
% Problem  : LG-4 depends on LG-2, LG-3
% Version  : 
% English  : Axiomatisations of the left group calculus are {LG-1, 
%            LG-2,LG-3,LG-4,LG-5} by Kalman, {LG-2,LG-3}, {LG-2,P-1}, 
%            {LG-2,P-4}, {LG-2,Q-1,Q-2}, {P-1,Q-3}, {P-4,Q-3}, {Q-1, 
%            Q-2,Q-3}, {Q-1,Q-3,Q-4}, {LG-27-1690} all by McCune. Show 
%            that LG-4 depends on a part of the Kalman system.

% Refs     : Lusk E., McCune W.W. (1992), Experiments with ROO, a Parallel 
%            Automated Deduction System, In Fronhofer B., 
%            Wrightson G. (Eds), Proceedings of the International Workshop 
%            on Parallelization in Inference Systems, (Dagstahl Castle, 
%            Germany, 1990), (Lecture Notes in Artificial Intelligence, 
%            590), Springer-Verlag, NY, 139-162.
%          : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Automated Discovery of New 
%            Axiomatisations of the Left Group and Right Group Calculi, 
%            In Journal of Automated Reasoning 9(1), Kluwer Academic 
%            Publishers, Dordrecht, The Netherlands, 1-24.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : CD-90 [Lusk & McCune, 1992]
%          : LG-90 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    4 (   0 non-Horn)(   3 unit)
%            Number of literals          :    6 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   5 constant)
%            Number of variables         :   11 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    7

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(lg_2,axiom,
    [++is_a_theorem(equivalent(equivalent(equivalent(equivalent(
equivalent(X,Y),equivalent(X,Z)),equivalent(Y,Z)),U),U))]).

input_clause(lg_3,axiom,
    [++is_a_theorem(equivalent(equivalent(equivalent(equivalent(
equivalent(equivalent(X,Y),equivalent(X,Z)),U),equivalent(
equivalent(Y,Z),U)),V),V))]).

input_clause(prove_lg_4,theorem,
    [--is_a_theorem(equivalent(equivalent(equivalent(
equivalent(a,b),c),e),equivalent(equivalent(equivalent(a,falsehood),c),
equivalent(equivalent(b,falsehood),e))))]).
%--------------------------------------------------------------------------
