%--------------------------------------------------------------------------
% File     : LCL085=Lk1_IC5-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implicational propositional)
% Problem  : IC-5 depends on the 1st Lukasiewicz axiom
% Version  : 
% English  : Axiomatisations of the Implicational propositional calculus 
%            are {IC-2,IC-3,IC-4} by Tarski-Bernays and single Lukasiewicz 
%            axioms. Show that IC-5 depends on the first Lukasiewicz 
%            axiom.

% Refs     : Lukasiewicz J. (1948), The Shortest Axiom of the 
%            Implicational Calculus of Propositions, Proceedings of the 
%            Royal Irish Academy 52(3), 25-33.
%          : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : IC-68 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   2 unit)
%            Number of literals          :    5 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    3 (   2 constant)
%            Number of variables         :    6 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(ic_JLukasiewicz,axiom,
    [++is_a_theorem(implies(implies(implies(X,Y),Z),
implies(implies(Z,X),implies(U,X))))]).

input_clause(prove_ic_5,theorem,
    [--is_a_theorem(implies(a,implies(implies(a,b),b)))]).
%--------------------------------------------------------------------------
