%--------------------------------------------------------------------------
% File     : LCL084=Lk1_IC4-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implicational propositional)
% Problem  : IC-4 depends on the 1st Lukasiewicz axiom
% Version  : Theorem formulation : Augmented.
% English  : Axiomatisations of the Implicational propositional calculus 
%            are {IC-2,IC-3,IC-4} by Tarski-Bernays and single Lukasiewicz 
%            axioms. Show that IC-4 depends on the first Lukasiewicz 
%            axiom.

% Refs     : Lukasiewicz J. (1948), The Shortest Axiom of the 
%            Implicational Calculus of Propositions, Proceedings of the 
%            Royal Irish Academy 52(3), 25-33.
%          : Pfenning F. (1988), Single Axioms in the Implicational 
%            Propositional Calculus, In Lusk E., Overbeek R. (Eds), 
%            Proceedings of the 9th International Conference on Automated 
%            Deduction (Argonne, IL, 1988), (Lecture Notes in Computer 
%            Science 310), Springer-Verlag, New York, NY, 710-713.
% Source   : [Pfenning, 1988]
% Names    : IH1 [Pfenning, 1988]
%          : ls6 [SETHEO]

% Status   : 
% Syntax   : Number of clauses           :    4 (   0 non-Horn)(   3 unit)
%            Number of literals          :    6 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :    7 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : Supplies IC-1 as an extra axiom.
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(ic_JLukasiewicz,axiom,
    [++is_a_theorem(implies(implies(implies(X,Y),Z),
implies(implies(Z,X),implies(U,X))))]).

input_clause(ic_1,axiom,
    [--is_a_theorem(implies(X,X))]).

input_clause(prove_ic_4,theorem,
    [--is_a_theorem(implies(implies(a,b),implies(implies(b,c),
implies(a,c))))]).
%--------------------------------------------------------------------------
