%--------------------------------------------------------------------------
% File     : LCL080=TB_Lk1-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implicational propositional)
% Problem  : The 1st Lukasiewicz axiom depends on Tarski-Bernays system
% Version  : Theorem formulation : Augmented.
% English  : Axiomatisations of the Implicational propositional calculus 
%            are {IC-2,IC-3,IC-4} by Tarski-Bernays and Lukasiewicz 
%            axioms. Show that the 1st Lukasiewicz axiom depends on the 
%            Tarski-Bernays system.

% Refs     : Lukasiewicz J. (1948), The Shortest Axiom of the 
%            Implicational Calculus of Propositions, Proceedings of the 
%            Royal Irish Academy 52(3), 25-33.
%          : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
% Source   : [TPTP]
% Names    : Problem 63 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    6 (   0 non-Horn)(   5 unit)
%            Number of literals          :    8 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   4 constant)
%            Number of variables         :   10 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : IC-1 is supplied as an extra axiom.
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(ic_1,axiom,
    [++is_a_theorem(implies(X,X))]).

input_clause(ic_2,axiom,
    [++is_a_theorem(implies(X,implies(Y,X)))]).

input_clause(ic_3,axiom,
    [++is_a_theorem(implies(implies(implies(X,Y),X),X))]).

input_clause(ic_4,axiom,
    [++is_a_theorem(implies(implies(X,Y),implies(implies(Y,Z),
implies(X,Z))))]).

input_clause(prove_ic_JLukasiewicz,theorem,
    [--is_a_theorem(implies(implies(implies(a,b),c),
implies(implies(c,a),implies(e,a))))]).
%--------------------------------------------------------------------------
