%--------------------------------------------------------------------------
% File     : LCL079=Ch_TR-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implication/Negation 2 valued sentential)
% Problem  : Transitivity can be derived from Church's system
% Version  : 
% English  : An axiomatisation of the Implication/Negation 2 valued 
%            sentential calculus is {CN-18,CN-35,CN-49} by Church. Show 
%            that transitivity of implies can be derived from the Church 
%            system.

% Refs     : 
% Source   : [ANL]
% Names    : morgan.one.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :    7 (   0 non-Horn)(   6 unit)
%            Number of literals          :    9 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :    9 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : Contributed to the ANL library by Charles Morgan.
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(cn_18,axiom,
    [++is_a_theorem(implies(X,implies(Y,X)))]).

input_clause(cn_35,axiom,
    [++is_a_theorem(implies(implies(X,implies(Y,Z)),
implies(implies(X,Y),implies(X,Z))))]).

input_clause(cn_49_reversed,axiom,
    [++is_a_theorem(implies(implies(Y,X),implies(not(X),not(Y))))]).

input_clause(a_implies_b,hypothesis,
    [++is_a_theorem(implies(a,b))]).

input_clause(b_implies_c,hypothesis,
    [++is_a_theorem(implies(b,c))]).

input_clause(prove_transitivity,theorem,
    [--is_a_theorem(implies(a,c))]).
%--------------------------------------------------------------------------
