%--------------------------------------------------------------------------
% File     : LCL076=Ch_CN40-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implication/Negation 2 valued sentential)
% Problem  : CN-40 depends on the Church system
% Version  : 
% English  : Axiomatisations of the Implication/Negation 2 valued 
%            sentential calculus are {CN-1,CN-2,CN-3} by Lukasiewicz, 
%            {CN-18,CN-21,CN-35,CN-39,CN-39,CN-40,CN-46} by Frege, 
%            {CN-3,CN-18,CN-21,CN-22,CN-30,CN-54} by Hilbert, {CN-18, 
%            CN-35,CN-49} by Church, {CN-19,CN-37,CN-59} by Lukasiewicz, 
%            {CN-19,CN-37,CN-60} by Wos, and the single Meredith axiom. 
%            Show that CN-40 depends on the Church system.

% Refs     : Morgan C. (1984), Logic Problems, AAR Newsletter 3, 5-5.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 66 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :    5 (   0 non-Horn)(   4 unit)
%            Number of literals          :    7 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    3 (   1 constant)
%            Number of variables         :    9 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(cn_18,axiom,
    [++is_a_theorem(implies(X,implies(Y,X)))]).

input_clause(cn_35,axiom,
    [++is_a_theorem(implies(implies(X,implies(Y,Z)),
implies(implies(X,Y),implies(X,Z))))]).

input_clause(cn_49,axiom,
    [++is_a_theorem(implies(implies(not(X),not(Y)),implies(Y,X)))]).

input_clause(prove_cn_40,theorem,
    [--is_a_theorem(implies(a,not(not(a))))]).
%--------------------------------------------------------------------------
