%--------------------------------------------------------------------------
% File     : LCL070=Ws_CN1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implication/Negation 2 valued sentential)
% Problem  : CN-1 depends on the Wos system
% Version  : 
% English  : Axiomatisations of the Implication/Negation 2 valued 
%            sentential calculus are {CN-1,CN-2,CN-3} by Lukasiewicz, 
%            {CN-18,CN-21,CN-35,CN-39,CN-39,CN-40,CN-46} by Frege, 
%            {CN-3,CN-18,CN-21,CN-22,CN-30,CN-54} by Hilbert, {CN-18, 
%            CN-35,CN-49} by Church, {CN-19,CN-37,CN-59} by Lukasiewicz, 
%            {CN-19,CN-37,CN-60} by Wos, and the single Meredith axiom. 
%            Show that CN-1 depends on the Wos system.

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : CN-31 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    5 (   0 non-Horn)(   4 unit)
%            Number of literals          :    7 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   12 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(cn_19,axiom,
    [++is_a_theorem(implies(implies(implies(X,Y),Z),implies(Y,Z)))]).

input_clause(cn_37,axiom,
    [++is_a_theorem(implies(implies(implies(X,Y),Z),
implies(not(X),Z)))]).

input_clause(cn_60,axiom,
    [++is_a_theorem(implies(implies(X,implies(not(Y),Z)),
implies(X,implies(implies(U,Z),implies(implies(Y,U),Z)))))]).

input_clause(prove_cn_1,theorem,
    [--is_a_theorem(implies(implies(a,b),
implies(implies(b,c),implies(a,c))))]).
%--------------------------------------------------------------------------
