%--------------------------------------------------------------------------
% File     : LCL064=Ch_CN1-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implication/Negation 2 valued sentential)
% Problem  : CN-1 depends on the Church system
% Version  : Theorem formulation : Reduced.
% English  : Axiomatisations of the Implication/Negation 2 valued 
%            sentential calculus are {CN-1,CN-2,CN-3} by Lukasiewicz, 
%            {CN-18,CN-21,CN-35,CN-39,CN-39,CN-40,CN-46} by Frege, 
%            {CN-3,CN-18,CN-21,CN-22,CN-30,CN-54} by Hilbert, {CN-18, 
%            CN-35,CN-49} by Church, {CN-19,CN-37,CN-59} by Lukasiewicz, 
%            {CN-19,CN-37,CN-60} by Wos, and the single Meredith axiom. 
%            Show that CN-1 depends on a simplified Church system.

% Refs     : 
% Source   : [ANL]
% Names    : morgan.six.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :    4 (   0 non-Horn)(   3 unit)
%            Number of literals          :    6 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :    7 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : Contributed to the ANL library by Charles Morgan.
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(cn_18,axiom,
    [++is_a_theorem(implies(X,implies(Y,X)))]).

input_clause(cn_35,axiom,
    [++is_a_theorem(implies(implies(X,implies(Y,Z)),
implies(implies(X,Y),implies(X,Z))))]).

input_clause(prove_cn_1,theorem,
    [--is_a_theorem(implies(implies(a,b),
implies(implies(b,c),implies(a,c))))]).
%--------------------------------------------------------------------------
