%--------------------------------------------------------------------------
% File     : LCL059=Lk_CN49-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implication/Negation 2 valued sentential)
% Problem  : CN-49 depends on the Lukasiewicz system
% Version  : 
% English  : Axiomatisations of the Implication/Negation 2 valued 
%            sentential calculus are {CN-1,CN-2,CN-3} by Lukasiewicz, 
%            {CN-18,CN-21,CN-35,CN-39,CN-39,CN-40,CN-46} by Frege, 
%            {CN-3,CN-18,CN-21,CN-22,CN-30,CN-54} by Hilbert, {CN-18, 
%            CN-35,CN-49} by Church, {CN-19,CN-37,CN-59} by Lukasiewicz, 
%            {CN-19,CN-37,CN-60} by Wos, and the single Meredith axiom. 
%            Show that CN-49 depends on the short Lukasiewicz system.

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : Wos, L (1992), An Opportunity to Test Your Skills-and the 
%            Power of Your Automated Reasoning Program, Association for 
%            Automated Reasoning Newsletter 21, 10-11.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : CN-20 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    5 (   0 non-Horn)(   4 unit)
%            Number of literals          :    7 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :    8 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(cn_1,axiom,
    [++is_a_theorem(implies(implies(X,Y),
implies(implies(Y,Z),implies(X,Z))))]).

input_clause(cn_2,axiom,
    [++is_a_theorem(implies(implies(not(X),X),X))]).

input_clause(cn_3,axiom,
    [++is_a_theorem(implies(X,implies(not(X),Y)))]).

input_clause(prove_cn_49,theorem,
    [--is_a_theorem(implies(implies(not(a),not(b)),implies(b,a)))]).
%--------------------------------------------------------------------------
