%--------------------------------------------------------------------------
% File     : LCL045=Hl_CN46-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implication/Negation 2 valued sentential)
% Problem  : CN-46 depends on Hilbert's system
% Version  : 
% English  : Two axiomatisations of the Implication/Negation 2 valued 
%            sentential calculus are {CN-18,CN-21,CN-35,CN-39,CN-39, 
%            CN-40,CN-46} by Frege and {CN-3,CN-18,CN-21,CN-22,CN-30, 
%            CN-54} by Hilbert. Show that CN-46 depends on the simplified 
%            Hilbert system (without CN-30).

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : CN-6 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    7 (   0 non-Horn)(   6 unit)
%            Number of literals          :    9 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   14 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(cn_3,axiom,
    [++is_a_theorem(implies(X,implies(not(X),Y)))]).

input_clause(cn_18,axiom,
    [++is_a_theorem(implies(X,implies(Y,X)))]).

input_clause(cn_21,axiom,
    [++is_a_theorem(implies(implies(X,implies(Y,Z)),
implies(Y,implies(X,Z))))]).

input_clause(cn_22,axiom,
    [++is_a_theorem(implies(implies(Y,Z),
implies(implies(X,Y),implies(X,Z))))]).

input_clause(cn_54,axiom,
    [++is_a_theorem(implies(implies(X,Y),
implies(implies(not(X),Y),Y)))]).

input_clause(prove_cn_46,theorem,
    [--is_a_theorem(implies(implies(a,b),implies(not(b),not(a))))]).
%--------------------------------------------------------------------------
