%--------------------------------------------------------------------------
% File     : LCL040=Fr_CN21-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implication/Negation 2 valued sentential)
% Problem  : CN-21 depends on the rest of Frege's system
% Version  : 
% English  : The first axiomatisation of Implication/Negation 2 valued 
%            sentential calculus was {CN-18,CN-21,CN-35,CN-39,CN-39, 
%            CN-40,CN-46} by Frege. Show, like Lukasiewicz did, that CN-21 
%            depends on the rest of this axiomatisation.

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : CN-1 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    7 (   0 non-Horn)(   6 unit)
%            Number of literals          :    9 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   11 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(cn_18,axiom,
    [++is_a_theorem(implies(X,implies(Y,X)))]).

input_clause(cn_35,axiom,
    [++is_a_theorem(implies(implies(X,implies(Y,Z)),
implies(implies(X,Y),implies(X,Z))))]).

input_clause(cn_39,axiom,
    [++is_a_theorem(implies(not(not(X)),X))]).

input_clause(cn_40,axiom,
    [++is_a_theorem(implies(X,not(not(X))))]).

input_clause(cn_46,axiom,
    [++is_a_theorem(implies(implies(X,Y),implies(not(Y),not(X))))]).

input_clause(prove_cn_21,theorem,
    [--is_a_theorem(implies(implies(a,implies(b,c)),
implies(b,implies(a,c))))]).
%--------------------------------------------------------------------------
