%--------------------------------------------------------------------------
% File     : LCL039=Modal-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implication/Negation 2 valued modal)
% Problem  : A theorem from Morgan
% Version  : 
% English  : An axiomatisation of the Implication/Negation 2 valued 
%            sentential calculus is {CN-18,CN-35,CN-49} by Church. This 
%            can be extended to the  modal logic T by the addition 
%            of three axioms for the modal operators. This problem proves 
%            a simple result of T.

% Refs     : Morgan C. (1984), Logic Problems, AAR Newsletter 3, 5-5.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 69 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :    8 (   0 non-Horn)(   6 unit)
%            Number of literals          :   11 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   1 constant)
%            Number of variables         :   13 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(cn_18,axiom,
    [++is_a_theorem(implies(X,implies(Y,X)))]).

input_clause(cn_35,axiom,
    [++is_a_theorem(implies(implies(X,implies(Y,Z)),
implies(implies(X,Y),implies(X,Z))))]).

input_clause(cn_49,axiom,
    [++is_a_theorem(implies(implies(not(X),not(Y)),implies(Y,X)))]).

input_clause(necessitation1,axiom,
    [++is_a_theorem(implies(necessary(implies(X,Y)),implies(
necessary(X),necessary(Y))))]).

input_clause(necessitation2,axiom,
    [++is_a_theorem(implies(necessary(X),X))]).

input_clause(axiom_of_necessitation,axiom,
    [--is_a_theorem(X),
     ++is_a_theorem(necessary(X))]).

input_clause(prove_this,theorem,
    [--is_a_theorem(implies(necessary(a),not(necessary(not(a)))))]).
%--------------------------------------------------------------------------
