%--------------------------------------------------------------------------
% File     : LCL038=Ov_C01-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implication/Falsehood 2 valued sentential)
% Problem  : C0-1 depends on a single axiom
% Version  : 
% English  : An axiomatisation for the Implication/Falsehood 2 valued 
%            sentential calculus is {C0-1,C0-2,C0-3,C0-4} 
%            by Tarski-Bernays. Show that C0-1 can be derived from this 
%            suspected single axiom.

% Refs     : Overbeek R. (1990), ATP competition announced at CADE-10.
%          : Overbeek R. (1993), The CADE-11 Competitions: A Personal 
%            View, Journal of Automated Reasoning 11(3), 315-316.
%          : Lusk E.L., McCune W.W. (1993), Uniform Strategies: The 
%            CADE-11 Theorem Proving Contest, Journal of Automated 
%            Reasoning 11(3), 317-331.
%          : Zhang H. (1993), Automated Proofs of Equality Problems 
%            in Overbeek's Competition, Journal of Automated Reasoning 
%            11(3), 333-351.
% Source   : [Overbeek, 1990]
% Names    : Overbeek Competition 5 [Overbeek, 1990]

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   2 unit)
%            Number of literals          :    5 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :    6 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(single_axiom,axiom,
    [++is_a_theorem(implies(implies(implies(X,Y),Z),
implies(implies(Z,X),implies(U,X))))]).

input_clause(prove_c0_1,theorem,
    [--is_a_theorem(implies(implies(a,b),implies(implies(b,c),
implies(a,c))))]).
%--------------------------------------------------------------------------
