%--------------------------------------------------------------------------
% File     : LCL032=CAM_C01-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implication/Falsehood 2 valued sentential)
% Problem  : C0-1 depends on the Merideth axiom
% Version  : 
% English  : Axiomatisations for the Implication/Falsehood 2 valued 
%            sentential calculus are {C0-1,C0-2,C0-3,C0-4} 
%            by Tarski-Bernays, {C0-2,C0-5,C0-6} by Church, and the single 
%            Meredith axioms. Show that C0-1 can be derived from the 
%            single Meredith axiom.

% Refs     : Meredith C.A. (1953), Single Axioms for the Systems (C,N), 
%            (C,0), and (A,N) of the Two-valued Propositional Calculus, 
%            Journal of Computing Systems 1, 155-164.
%          : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : C0-44 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   2 unit)
%            Number of literals          :    5 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   4 constant)
%            Number of variables         :    7 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(c0_CAMerideth,axiom,
    [++is_a_theorem(implies(implies(implies(implies(implies(X,Y),
implies(Z,falsehood)),U),V),implies(implies(V,X),implies(Z,X))))]).

input_clause(prove_c0_1,theorem,
    [--is_a_theorem(implies(implies(a,b),implies(implies(b,c),
implies(a,c))))]).
%--------------------------------------------------------------------------
