%--------------------------------------------------------------------------
% File     : LCL025=Ch_C01-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Implication/Falsehood 2 valued sentential)
% Problem  : C0-1 depends on the Church system
% Version  : 
% English  : Axiomatisations for the Implication/Falsehood 2 valued 
%            sentential calculus are {C0-1,C0-2,C0-3,C0-4} 
%            by Tarski-Bernays, {C0-2,C0-5,C0-6} by Church, and the single 
%            Meredith axioms. Show that C0-1 can be derived from the 
%            Church system.

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : C0-37 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    5 (   0 non-Horn)(   4 unit)
%            Number of literals          :    7 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   4 constant)
%            Number of variables         :    8 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(c0_2,axiom,
    [++is_a_theorem(implies(X,implies(Y,X)))]).

input_clause(c0_5,axiom,
    [++is_a_theorem(implies(implies(implies(X,falsehood),
falsehood),X))]).

input_clause(c0_6,axiom,
    [++is_a_theorem(implies(implies(X,implies(Y,Z)),
implies(implies(X,Y),implies(X,Z))))]).

input_clause(prove_c0_1,theorem,
    [--is_a_theorem(implies(implies(a,b),implies(implies(b,c),
implies(a,c))))]).
%--------------------------------------------------------------------------
