%--------------------------------------------------------------------------
% File     : LCL024=XGK_PYO-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Equivalential)
% Problem  : PYO depends on XGK
% Version  : 
% English  : Show that Kalman's shortest single axiom for the 
%            equivalential calculus, XGK, can be derived from the Meredith 
%            single axiom PYO.

% Refs     : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
%          : Overbeek R. (1990), ATP competition announced at CADE-10.
%          : Overbeek R. (1993), The CADE-11 Competitions: A Personal 
%            View, Journal of Automated Reasoning 11(3), 315-316.
%          : Lusk E.L., McCune W.W. (1993), Uniform Strategies: The 
%            CADE-11 Theorem Proving Contest, Journal of Automated 
%            Reasoning 11(3), 317-331.
%          : Zhang H. (1993), Automated Proofs of Equality Problems 
%            in Overbeek's Competition, Journal of Automated Reasoning 
%            11(3), 333-351.
% Source   : [Overbeek, 1990]
% Names    : Test Problem 16 [Wos, 1988]
%          : XGK and Equivalential Calculus [Wos, 1988]
%          : Overbeek Competition 4 [Overbeek, 1990]

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   2 unit)
%            Number of literals          :    5 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :    5 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

%----Axiom by Kalman 
input_clause(prove_xgk,axiom,
    [++is_a_theorem(equivalent(X,equivalent(equivalent(Y,
equivalent(Z,X)),equivalent(Z,Y))))]).

%----Axiom by Meredith 
input_clause(prove_pyo,theorem,
    [--is_a_theorem(equivalent(equivalent(equivalent(a,
equivalent(b,c)),c),equivalent(b,a)))]).
%--------------------------------------------------------------------------
