%--------------------------------------------------------------------------
% File     : LCL022=YQL_EC1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Equivalential)
% Problem  : EC-1 depends on YQL
% Version  : 
% English  : An axiomatisation of the equivalential calculus is {EC-1, 
%            EC-2} by Lesniewski. Show that EC-1 can be derived from the 
%            single Lukasiewicz axiom YQL.

% Refs     : 
% Source   : [OTTER]
% Names    : ec.in part 1 [OTTER]

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   2 unit)
%            Number of literals          :    5 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :    5 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

%----Axiom by Lukasiewicz 
input_clause(yql,axiom,
    [++is_a_theorem(equivalent(equivalent(X,Y),equivalent(
equivalent(Z,Y),equivalent(X,Z))))]).

%----Axiom of symmetry 
input_clause(prove_ec_1,theorem,
    [--is_a_theorem(equivalent(equivalent(equivalent(a,b),
equivalent(c,a)),equivalent(b,c)))]).
%--------------------------------------------------------------------------
