%--------------------------------------------------------------------------
% File     : LCL014=WN_XGF-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Equivalential)
% Problem  : XGF depends on WN
% Version  : 
% English  : Show that the single Meredith axiom XGF can be derived from 
%            the single Meredith axiom WN.

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : EC-77 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   2 unit)
%            Number of literals          :    5 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :    5 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

%----Axiom by Meredith 
input_clause(wn,axiom,
    [++is_a_theorem(equivalent(equivalent(X,equivalent(Y,Z)),
equivalent(Z,equivalent(X,Y))))]).

%----Axiom by Meredith 
input_clause(prove_xgf,theorem,
    [--is_a_theorem(equivalent(a,equivalent(equivalent(b,
equivalent(a,c)),equivalent(c,b))))]).
%--------------------------------------------------------------------------
