%--------------------------------------------------------------------------
% File     : LCL010=YQF_YQL-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Equivalential)
% Problem  : YQL depends on YQF
% Version  : 
% English  : Show that the single Lukasiewicz axiom YQL can be derived 
%            from the single Lukasiewicz axiom YQF.

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : EC-73 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   2 unit)
%            Number of literals          :    5 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :    5 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

%----Axiom by Lukasiewicz 
input_clause(yqf,axiom,
    [++is_a_theorem(equivalent(equivalent(X,Y),equivalent(
equivalent(X,Z),equivalent(Z,Y))))]).

%----Axiom by Lukasiewicz 
input_clause(prove_yql,theorem,
    [--is_a_theorem(equivalent(equivalent(a,b),equivalent(
equivalent(c,b),equivalent(a,c))))]).
%--------------------------------------------------------------------------
