%--------------------------------------------------------------------------
% File     : LCL008=YQL_EC4-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Equivalential)
% Problem  : EC-4 depends on YQL
% Version  : 
% English  : An axiomatisation of the equivalential calculus is {EC-4, 
%            EC-5} by Wajsburg. Show that EC-4 can be derived from the 
%            single Lukasiewicz axiom YQL.

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : EC-71 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   2 unit)
%            Number of literals          :    5 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    3 (   2 constant)
%            Number of variables         :    5 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

%----Axiom by Lukasiewicz 
input_clause(yql,axiom,
    [++is_a_theorem(equivalent(equivalent(X,Y),equivalent(
equivalent(Z,Y),equivalent(X,Z))))]).

%----Axiom of symmetry 
input_clause(prove_ec_4,theorem,
    [--is_a_theorem(equivalent(equivalent(a,b),equivalent(b,a)))]).
%--------------------------------------------------------------------------
