%--------------------------------------------------------------------------
% File     : LCL006=Wj_EC1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Equivalential)
% Problem  : EC-1 depends on the Wajsberg system
% Version  : 
% English  : Two axiomatisations of the equivalential calculus are 
%            {EC-1,EC-2} by Lesniewski, and {EC-4,EC-5} by Wajsburg. Show 
%            that EC-1 can be derived from the Wajsburg system.

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : EC-69 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    4 (   0 non-Horn)(   3 unit)
%            Number of literals          :    6 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :    7 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

%----Axiom of symmetry 
input_clause(ec_4,axiom,
    [++is_a_theorem(equivalent(equivalent(X,Y),equivalent(Y,X)))]).

%----Axiom of associativity 
input_clause(ec_5,axiom,
    [++is_a_theorem(equivalent(equivalent(equivalent(X,Y),Z),
equivalent(X,equivalent(Y,Z))))]).

input_clause(prove_ec_1,theorem,
    [--is_a_theorem(equivalent(equivalent(equivalent(a,b),
equivalent(c,a)),equivalent(b,c)))]).
%--------------------------------------------------------------------------
