%--------------------------------------------------------------------------
% File     : LCL001=WR_CAM-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Disjunction/Negation 2 valued sentential)
% Problem  : The Whitehead-Russell system => the Meredith axiom
% Version  : 
% English  : The Whitehead-Russell axiomatisation of the Disjunction/ 
%            Negation 2 valued sentential calculus is {AN-1,AN-2,AN-3, 
%            AN-4}. Show that the Merideth axiom can be derived from the 
%            Whitehead-Russell axiomatisation.

% Refs     : Meredith C.A. (1953), Single Axioms for the Systems (C,N), 
%            (C,0), and (A,N) of the Two-valued Propositional Calculus, 
%            Journal of Computing Systems 1, 155-164.
%          : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : AN-50 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    6 (   0 non-Horn)(   5 unit)
%            Number of literals          :    8 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   5 constant)
%            Number of variables         :   10 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    7

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(or(not(X),Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(an_1,axiom,
    [++is_a_theorem(or(not(or(not(Y),Z)),or(not(or(X,Y)),or(X,Z))))]).

input_clause(an_2,axiom,
    [++is_a_theorem(or(not(or(X,Y)),or(Y,X)))]).

input_clause(an_3,axiom,
    [++is_a_theorem(or(not(X),or(Y,X)))]).

input_clause(an_4,axiom,
    [++is_a_theorem(or(not(or(X,X)),X))]).

input_clause(prove_an_CAMerideth,theorem,
    [--is_a_theorem(or(not(or(not(or(not(a),b)),or(c,or(e,
falsehood)))),or(not(or(not(e),a)),or(c,or(falsehood,a)))))]).
%--------------------------------------------------------------------------
