%--------------------------------------------------------------------------
% File     : LAT005=SAMsLem-6 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Lattice Theory
% Problem  : SAM's lemma
% Version  : [Wos, 1988] axioms.
% English  : Let L be a modular lattice with 0 and 1.  Suppose that A and 
%            B are elements of L such that (A v B) and (A ^ B) both have 
%            not necessarily unique complements. Then, (A v B)' = 
%            ((A v B)' v ((A ^ B)' ^ B)) ^ ((A v B)' v ((A ^ B)' ^ A)).

% Refs     : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
% Source   : [Wos, 1988]
% Names    : Test Problem 12 [Wos, 1988]
%          : SAM's lemma [Wos, 1988]

% Status   : 
% Syntax   : Number of clauses           :   50 (   0 non-Horn)(  24 unit)
%            Number of literals          :  105 (  22 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   14 (  12 constant)
%            Number of variables         :  124 (   6 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : This uses the fixed version of the [McCharen, et al., 1976] 
%            axioms, plus some redundant extras.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Lattice theory axioms 
include('Axioms/LAT002-0.ax').
include('Axioms/LAT002-0.eq').
%--------------------------------------------------------------------------
%----Redundant commuted version 
input_clause(join_x_and_1,axiom,
    [++join(X,1,1)]).

%----Redundant commuted version 
input_clause(join_x_and_0,axiom,
    [++join(X,0,X)]).

%----Redundant commuted version 
input_clause(meet_x_and_0,axiom,
    [++meet(X,0,0)]).

%----Redundant commuted version 
input_clause(meet_x_and_1,axiom,
    [++meet(X,1,X)]).

%----These two are extra modularity axioms (X ^ Z) = Z implies that 
%----(X ^ (Y v Z)) = (Z v (X ^ Y)), 
input_clause(modularity3,axiom,
    [--meet(X,Z,Z),
     --join(Y,Z,Y1),
     --meet(X,Y,X1),
     --meet(X,Y1,Z1),
     ++join(Z,X1,Z1)]).

input_clause(modularity4,axiom,
    [--meet(X,Z,Z),
     --join(Y,Z,Y1),
     --meet(X,Y,X1),
     --join(Z,X1,Z1),
     ++meet(X,Y1,Z1)]).

%----Negation of Sams Lemma :
%----This version is not as it appears in [McCharen, et al., 1986] Rather 
%----it has been taken from the OTTER version, which corresponds to [Wos, 
%----1988] 
input_clause(meet_a_and_b,theorem,
    [++meet(a,b,c)]).

input_clause(join_c_and_r2,theorem,
    [++join(c,r2,1)]).

input_clause(meet_c_and_r2,theorem,
    [++meet(c,r2,0)]).

input_clause(meet_r2_and_b,theorem,
    [++meet(r2,b,e)]).

input_clause(join_a_and_b,theorem,
    [++join(a,b,c2)]).

input_clause(join_c2_and_r1,theorem,
    [++join(c2,r1,1)]).

input_clause(meet_c2_and_r1,theorem,
    [++meet(c2,r1,0)]).

input_clause(meet_r2_and_a,theorem,
    [++meet(r2,a,d)]).

input_clause(join_r1_and_e,theorem,
    [++join(r1,e,a2)]).

input_clause(join_r1_and_d,theorem,
    [++join(r1,d,b2)]).

input_clause(meet_a2_and_b2,theorem,
    [--meet(a2,b2,r1)]).
%--------------------------------------------------------------------------
