%--------------------------------------------------------------------------
% File     : LAT005=SAMsLem-5 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Lattice Theory
% Problem  : SAM's lemma
% Version  : [McCharen, et al., 1976] axioms :
%            Incomplete > Reduced & Augmented > Complete.
% English  : Let L be a modular lattice with 0 and 1.  Suppose that A and 
%            B are elements of L such that (A v B) and (A ^ B) both have 
%            not necessarily unique complements. Then, (A v B)' = 
%            ((A v B)' v ((A ^ B)' ^ B)) ^ ((A v B)' v ((A ^ B)' ^ A)).

% Refs     : Guard J., Oglesby F., Bennet J. and Settle L. (1969), 
%            Semi-automated Mathematics, Journal of the ACM 16, 49-62.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : SAMslemma.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   44 (   0 non-Horn)(  20 unit)
%            Number of literals          :   91 (  22 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   14 (  12 constant)
%            Number of variables         :  108 (   4 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : This uses the fixed version of the [McCharen, et al., 1976] 
%            axioms.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Lattice theory axioms 
include('Axioms/LAT002-0.ax').
include('Axioms/LAT002-0.eq').
%--------------------------------------------------------------------------
%----Negation of Sams Lemma :
%----This version is not as it appears in [McCharen, et al., 1986] Rather 
%----it has been taken from the OTTER version, which corresponds to [Wos, 
%----1988] 
input_clause(meet_a_and_b,theorem,
    [++meet(a,b,c)]).

input_clause(join_c_and_r2,theorem,
    [++join(c,r2,1)]).

input_clause(meet_c_and_r2,theorem,
    [++meet(c,r2,0)]).

input_clause(meet_r2_and_b,theorem,
    [++meet(r2,b,e)]).

input_clause(join_a_and_b,theorem,
    [++join(a,b,c2)]).

input_clause(join_c2_and_r1,theorem,
    [++join(c2,r1,1)]).

input_clause(meet_c2_and_r1,theorem,
    [++meet(c2,r1,0)]).

input_clause(meet_r2_and_a,theorem,
    [++meet(r2,a,d)]).

input_clause(join_r1_and_e,theorem,
    [++join(r1,e,a2)]).

input_clause(join_r1_and_d,theorem,
    [++join(r1,d,b2)]).

input_clause(meet_a2_and_b2,theorem,
    [--meet(a2,b2,r1)]).
%--------------------------------------------------------------------------
