%--------------------------------------------------------------------------
% File     : LAT005=SAMsLem-4 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Lattice Theory
% Problem  : SAM's lemma
% Version  : [McCune, 1988] (equality) axioms.
%            Theorem formulation : No explicit complement.
% English  : Let L be a modular lattice with 0 and 1.  Suppose that A and 
%            B are elements of L such that (A v B) and (A ^ B) both have 
%            not necessarily unique complements. Then, (A v B)' = 
%            ((A v B)' v ((A ^ B)' ^ B)) ^ ((A v B)' v ((A ^ B)' ^ A)).

% Refs     : McCune W. (1988), Challenge Equality Problems in Lattice 
%            Theory, In Lusk E., Overbeek R. (Eds), Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988) (Lecture Notes in Computer Science 310), 
%            Springer-Verlag, New York, NY, 704-709.
%          : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
% Source   : [Wos, 1988]
% Names    : Test Problem 12 [Wos, 1988]
%          : SAM's lemma [Wos, 1988]

% Status   : 
% Syntax   : Number of clauses           :   27 (   0 non-Horn)(  20 unit)
%            Number of literals          :   35 (  35 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   10 (   8 constant)
%            Number of variables         :   41 (   4 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : The [Wos, 1988] version has four redundant axioms that are 
%            not included here.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include lattice axioms 
include('Axioms/LAT001-0.ax').
%--------------------------------------------------------------------------
input_clause(r2_complement_meet_a_b_1,theorem,
    [++equal(join(r2,meet(a,b)),1)]).

input_clause(r2_complement_meet_a_b_2,theorem,
    [++equal(meet(r2,meet(a,b)),0)]).

input_clause(r1_complement_join_a_b_1,theorem,
    [++equal(join(r1,join(a,b)),1)]).

input_clause(r1_complement_join_a_b_2,theorem,
    [++equal(meet(r1,join(a,b)),0)]).

input_clause(define_b2,theorem,
    [++equal(join(r1,meet(a,r2)),b2)]).

input_clause(define_a2,theorem,
    [++equal(join(r1,meet(b,r2)),a2)]).

input_clause(prove_SAMs_lemma,theorem,
    [--equal(meet(a2,b2),r1)]).
%--------------------------------------------------------------------------
