%--------------------------------------------------------------------------
% File     : LAT005=SAMsLem-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Lattice Theory
% Problem  : SAM's lemma
% Version  : [McCune, 1988] (equality) axioms.
% English  : Let L be a modular lattice with 0 and 1.  Suppose that A and 
%            B are elements of L such that (A v B) and (A ^ B) both have 
%            not necessarily unique complements. Then, (A v B)' = 
%            ((A v B)' v ((A ^ B)' ^ B)) ^ ((A v B)' v ((A ^ B)' ^ A)).

% Refs     : Guard J., Oglesby F., Bennet J. and Settle L. (1969), 
%            Semi-automated Mathematics, Journal of the ACM 16, 49-62.
%          : McCune W. (1988), Challenge Equality Problems in Lattice 
%            Theory, In Lusk E., Overbeek R. (Eds), Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988) (Lecture Notes in Computer Science 310), 
%            Springer-Verlag, New York, NY, 704-709.
% Source   : [McCune, 1988]
% Names    : SAM's lemma [McCune, 1988]

% Status   : 
% Syntax   : Number of clauses           :   28 (   0 non-Horn)(  16 unit)
%            Number of literals          :   44 (  35 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    8 (   6 constant)
%            Number of variables         :   53 (   4 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : [McCune, 1988] specifies that the axioms for complement 
%            should not be included ("clauses 1-13 from axioms"). However, 
%            if this makes clauses 87 and 88 pure. I have assumed a typo 
%            in the paper and included axioms 14-16.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include lattice axioms 
include('Axioms/LAT001-0.ax').
include('Axioms/LAT001-1.ax').
%--------------------------------------------------------------------------
input_clause(complement_of_a_join_b,hypothesis,
    [++complement(r1,join(a,b))]).

input_clause(complement_of_a_meet_b,hypothesis,
    [++complement(r2,meet(a,b))]).

input_clause(prove_lemma,theorem,
    [--equal(r1,meet(join(r1,meet(r2,b)),join(r1,meet(r2,a))))]).
%--------------------------------------------------------------------------
