%--------------------------------------------------------------------------
% File     : LAT005=SAMsLem-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Lattice Theory
% Problem  : SAM's lemma
% Version  : [McCharen, et al., 1976] axioms : Incomplete.
% English  : Let L be a modular lattice with 0 and 1.  Suppose that A and 
%            B are elements of L such that (A v B) and (A ^ B) both have 
%            not necessarily unique complements. Then, (A v B)' = 
%            ((A v B)' v ((A ^ B)' ^ B)) ^ ((A v B)' v ((A ^ B)' ^ A)).

% Refs     : Guard J., Oglesby F., Bennet J. and Settle L. (1969), 
%            Semi-automated Mathematics, Journal of the ACM 16, 49-62.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : SAM's lemma [McCharen, et al., 1976]
%          : SAMslemma.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   29 (   0 non-Horn)(  17 unit)
%            Number of literals          :   61 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   12 (  12 constant)
%            Number of variables         :   66 (   4 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    1

% Comments : This omits the total function axioms and adds redundant 
%            modularity axioms.
%--------------------------------------------------------------------------
%----Include Lattice theory axioms 
% include('Axioms/LAT002-0.ax').
%--------------------------------------------------------------------------
%----Union of 1 and x is equal to 1 :  (1 v X) = 1 
input_clause(join_1_and_x,axiom,
    [++join(1,X,1)]).

%----Union of x with itself is equal to x :  (X v X) = X 
input_clause(join_x_and_x,axiom,
    [++join(X,X,X)]).

%----Union of 0 and x is equal to x :  (0 v X) = X 
input_clause(join_0_and_x,axiom,
    [++join(0,X,X)]).

%----Intersection of 0 and x is equal to 0 : (0 ^ X) = 0 
input_clause(meet_0_and_x,axiom,
    [++meet(0,X,0)]).

%----Intersection of x and itself is equal to x : (X ^ X) = X 
input_clause(meet_x_and_x,axiom,
    [++meet(X,X,X)]).

%----Intersection of 1 and x is equal to itself : (1 ^ X) = X 
input_clause(meet_1_and_x,axiom,
    [++meet(1,X,X)]).

%----Intersection of x and y , is the same as meet of y and x.
%----  (X ^ Y) = (Y ^ X), 
input_clause(commutativity_of_meet,axiom,
    [--meet(X,Y,Z),
     ++meet(Y,X,Z)]).

%----Union of x and y is the same as join of y and x. (X v Y) = (Y v X), 
input_clause(commutativity_of_join,axiom,
    [--join(X,Y,Z),
     ++join(Y,X,Z)]).

%----Union of x with the meet of x and y is the same as x.
%----  X v (X ^ Y) = X 
input_clause(absorbtion1,axiom,
    [--meet(X,Y,Z),
     ++join(X,Z,X)]).

%----Intersection  of x with the join of x and y is the same as x.
%----  X ^ (X v Y) = X 
input_clause(absorbtion2,axiom,
    [--join(X,Y,Z),
     ++meet(X,Z,X)]).

%----The operation '^', meet ,is associative
%----  X ^ (Y ^ Z) = (X ^ Y) ^ Z 
input_clause(associativity_of_meet1,axiom,
    [--meet(X,Y,Xy),
     --meet(Y,Z,Yz),
     --meet(X,Yz,Xyz),
     ++meet(Xy,Z,Xyz)]).

input_clause(associativity_of_meet2,axiom,
    [--meet(X,Y,Xy),
     --meet(Y,Z,Yz),
     --meet(Xy,Z,Xyz),
     ++meet(X,Yz,Xyz)]).

%----The operation 'v' is associative X v (Y v Z) = (X v Y) v Z 
input_clause(associativity_of_join1,axiom,
    [--join(X,Y,Xy),
     --join(Y,Z,Yz),
     --join(X,Yz,Xyz),
     ++join(Xy,Z,Xyz)]).

input_clause(associativity_of_join2,axiom,
    [--join(X,Y,Xy),
     --join(Y,Z,Yz),
     --join(Xy,Z,Xyz),
     ++join(X,Yz,Xyz)]).

%----(X ^ Z) = X implies that (Z ^ (X v Y)) =  (X v (Y ^ Z)), 
input_clause(modularity1,axiom,
    [--meet(X,Z,X),
     --join(X,Y,X1),
     --meet(Y,Z,Y1),
     --meet(Z,X1,Z1),
     ++join(X,Y1,Z1)]).

input_clause(modularity2,axiom,
    [--meet(X,Z,X),
     --join(X,Y,X1),
     --meet(Y,Z,Y1),
     --join(X,Y1,Z1),
     ++meet(Z,X1,Z1)]).

%----These two are extra modularity axioms (X ^ Z) = Z implies that 
%----(X ^ (Y v Z)) = (Z v (X ^ Y)), 
input_clause(modularity3,axiom,
    [--meet(X,Z,Z),
     --join(Y,Z,Y1),
     --meet(X,Y,X1),
     --meet(X,Y1,Z1),
     ++join(Z,X1,Z1)]).

input_clause(modularity4,axiom,
    [--meet(X,Z,Z),
     --join(Y,Z,Y1),
     --meet(X,Y,X1),
     --join(Z,X1,Z1),
     ++meet(X,Y1,Z1)]).

%----Negation of Sams Lemma :
%----This version is not as it appears in [McCharen, et al., 1986] Rather 
%----it has been taken from the OTTER version, which corresponds to [Wos, 
%----1988] 
input_clause(meet_a_and_b,theorem,
    [++meet(a,b,c)]).

input_clause(join_c_and_r2,theorem,
    [++join(c,r2,1)]).

input_clause(meet_c_and_r2,theorem,
    [++meet(c,r2,0)]).

input_clause(meet_r2_and_b,theorem,
    [++meet(r2,b,e)]).

input_clause(join_a_and_b,theorem,
    [++join(a,b,c2)]).

input_clause(join_c2_and_r1,theorem,
    [++join(c2,r1,1)]).

input_clause(meet_c2_and_r1,theorem,
    [++meet(c2,r1,0)]).

input_clause(meet_r2_and_a,theorem,
    [++meet(r2,a,d)]).

input_clause(join_r1_and_e,theorem,
    [++join(r1,e,a2)]).

input_clause(join_r1_and_d,theorem,
    [++join(r1,d,b2)]).

input_clause(meet_a2_and_b2,theorem,
    [--meet(a2,b2,r1)]).
%--------------------------------------------------------------------------
