%--------------------------------------------------------------------------
% File     : LAT004=Eqn3-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Lattice Theory
% Problem  : A fairly complex equation to establish
% Version  : [McCune, 1988] (equality) axioms.
% English  : If X' = U v V and Y' = U ^ V and U" = UC and V" = VC then 
%            (U v V)" = (UC ^ VC). " means unique complement.

% Refs     : Bumcroft R. (1965), Proceedings of the Glasgow Mathematical 
%            Association 7(1), 22-23.
%          : Guard J., Oglesby F., Bennet J. and Settle L. (1969), 
%            Semi-automated Mathematics, Journal of the ACM 16, 49-62.
%          : McCune W. (1988), Challenge Equality Problems in Lattice 
%            Theory, In Lusk E., Overbeek R. (Eds), Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988) (Lecture Notes in Computer Science 310), 
%            Springer-Verlag, New York, NY, 704-709.
% Source   : [McCune, 1988]
% Names    : L3 [McCune, 1988]

% Status   : 
% Syntax   : Number of clauses           :   38 (   1 non-Horn)(  18 unit)
%            Number of literals          :   67 (  42 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (   8 constant)
%            Number of variables         :   74 (   4 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include lattice axioms 
include('Axioms/LAT001-0.ax').
%----Include definition of complement 
include('Axioms/LAT001-1.ax').
%----Include definition of unique complement 
include('Axioms/LAT001-2.ax').
%--------------------------------------------------------------------------
input_clause(complement_of_a_join_b,hypothesis,
    [++complement(r1,join(a,b))]).

input_clause(complement_of_a_meet_b,hypothesis,
    [++complement(r2,meet(a,b))]).

input_clause(unique_complement_of_a,hypothesis,
    [++unique_complement(a,a2)]).

input_clause(unique_complement_of_b,hypothesis,
    [++unique_complement(b,b2)]).

input_clause(prove_unique_complement,theorem,
    [--unique_complement(join(a,b),meet(a2,b2))]).
%--------------------------------------------------------------------------
