%--------------------------------------------------------------------------
% File     : LAT002=ExEqn1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Lattice Theory
% Problem  : If X' = U v V and Y' = U ^ V, then U' exists
% Version  : [McCune, 1988] (equality) axioms.
% English  : The theorem states that there is a complement of "a" 
%            in a modular lattice with 0 and 1.

% Refs     : Bumcroft R. (1965), Proceedings of the Glasgow Mathematical 
%            Association 7(1), 22-23.
%          : Guard J., Oglesby F., Bennet J. and Settle L. (1969), 
%            Semi-automated Mathematics, Journal of the ACM 16, 49-62.
%          : McCune W. (1988), Challenge Equality Problems in Lattice 
%            Theory, In Lusk E., Overbeek R. (Eds), Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988) (Lecture Notes in Computer Science 310), 
%            Springer-Verlag, New York, NY, 704-709.
% Source   : [McCune, 1988]
% Names    : L1b [McCune, 1988]

% Status   : 
% Syntax   : Number of clauses           :   28 (   0 non-Horn)(  16 unit)
%            Number of literals          :   44 (  34 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    8 (   6 constant)
%            Number of variables         :   54 (   5 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include lattice axioms 
include('Axioms/LAT001-0.ax').
%----Include definition of complement 
include('Axioms/LAT001-1.ax').
%--------------------------------------------------------------------------
input_clause(complement_of_a_join_b,hypothesis,
    [++complement(r1,join(a,b))]).

input_clause(complement_of_a_meet_b,hypothesis,
    [++complement(r2,meet(a,b))]).

input_clause(prove_complememt_exists,theorem,
    [--complement(a,W)]).
%--------------------------------------------------------------------------
