%--------------------------------------------------------------------------
% File     : HEN011=OpComm-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : This operation is commutative
% Version  : [McCharen, et al., 1976] (equality) axioms :
%            Reduced & Augmented > Complete.
% English  : Define & on the set of Z', where Z' = identity/Z, 
%            by X' & Y' = X'/(identity/Y'). The operation is commutative.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : H11 [McCharen, et al., 1976]
%          : hp11.ver3.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   24 (   0 non-Horn)(  15 unit)
%            Number of literals          :   36 (  36 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    9 (   8 constant)
%            Number of variables         :   37 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : less_equal replaced by divides
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms, for the equality formulation with 
%----less_equals removed.
include('Axioms/HEN003-0.ax').
%--------------------------------------------------------------------------
input_clause(x_divide_x_is_zero,axiom,
    [++equal(divide(X,X),zero)]).

input_clause(x_divide_zero_is_x,axiom,
    [++equal(divide(X,zero),X)]).

input_clause(transitivity_of_divide_to_zero,axiom,
    [--equal(divide(X,Y),zero),
     --equal(divide(Y,Z),zero),
     ++equal(divide(X,Z),zero)]).

input_clause(property_of_divide1,axiom,
    [--equal(divide(divide(X,Y),Z),zero),
     ++equal(divide(divide(X,Z),Y),zero)]).

input_clause(property_of_divide2,axiom,
    [--equal(divide(X,Y),zero),
     ++equal(divide(divide(Z,Y),divide(Z,X)),zero)]).

input_clause(property_of_divide3,axiom,
    [--equal(divide(X,Y),zero),
     ++equal(divide(divide(X,Z),divide(Y,Z)),zero)]).

input_clause(one_inversion_equals_three,axiom,
    [++equal(divide(identity,divide(identity,divide(identity,X))),
divide(identity,X))]).

input_clause(property_of_inversion,axiom,
    [++equal(divide(divide(identity,X),divide(identity,
divide(identity,X))),divide(identity,X))]).

input_clause(part_of_theorem,hypothesis,
    [--equal(divide(divide(identity,a),divide(identity,divide(identity,b))),divide(divide(identity,b),divide(identity,divide(identity,a))))]).

input_clause(identity_divide_a_is_c,hypothesis,
    [++equal(divide(identity,a),c)]).

input_clause(identity_divide_b_is_d,hypothesis,
    [++equal(divide(identity,b),d)]).

input_clause(identity_divide_c_is_e,hypothesis,
    [++equal(divide(identity,c),e)]).

input_clause(identity_divide_d_is_g,hypothesis,
    [++equal(divide(identity,d),g)]).

input_clause(prove_commutativity,theorem,
    [--equal(divide(c,g),divide(d,e))]).
%--------------------------------------------------------------------------
