%--------------------------------------------------------------------------
% File     : HEN011=OpComm-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : This operation is commutative
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : Define & on the set of Z', where Z' = identity/Z, 
%            by X' & Y' = X'/(identity/Y'). The operation is commutative.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : H11 [McCharen, et al., 1976]
%          : hp11.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   30 (   0 non-Horn)(  17 unit)
%            Number of literals          :   48 (  27 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    9 (   8 constant)
%            Number of variables         :   48 (   5 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms for equality formulation 
include('Axioms/HEN002-0.ax').
include('Axioms/HEN002-0.eq').
%--------------------------------------------------------------------------
input_clause(everything_divide_id_is_zero,axiom,
    [++equal(divide(X,identity),zero)]).

input_clause(zero_divide_anything_is_zero,axiom,
    [++equal(divide(zero,X),zero)]).

input_clause(x_divide_x_is_zero,axiom,
    [++equal(divide(X,X),zero)]).

input_clause(x_divide_zero_is_x,axiom,
    [++equal(divide(a,zero),a)]).

input_clause(transitivity_of_less_equal,axiom,
    [--less_equal(X,Y),
     --less_equal(Y,Z),
     ++less_equal(X,Z)]).

input_clause(property_of_divide1,axiom,
    [--less_equal(divide(X,Y),Z),
     ++less_equal(divide(X,Z),Y)]).

input_clause(property_of_divide2,axiom,
    [--less_equal(X,Y),
     ++less_equal(divide(Z,Y),divide(Z,X))]).

input_clause(property_of_divide3,axiom,
    [--less_equal(X,Y),
     ++less_equal(divide(X,Z),divide(Y,Z))]).

input_clause(one_inversion_equals_three,axiom,
    [++equal(divide(identity,divide(identity,divide(identity,X))),
divide(identity,X))]).

input_clause(property_of_inversion,axiom,
    [++equal(divide(divide(identity,X),divide(identity,
divide(identity,X))),divide(identity,X))]).

input_clause(part_of_theorem,hypothesis,
    [--equal(divide(divide(identity,a),divide(identity,
divide(identity,b))),divide(divide(identity,b),divide(identity,
divide(identity,a))))]).

input_clause(identity_divide_a,hypothesis,
    [++equal(divide(identity,a),c)]).

input_clause(identity_divide_b,hypothesis,
    [++equal(divide(identity,b),d)]).

input_clause(identity_divide_c,hypothesis,
    [++equal(divide(identity,c),e)]).

input_clause(identity_divide_d,hypothesis,
    [++equal(divide(identity,d),g)]).

input_clause(prove_commutativity,theorem,
    [--equal(divide(c,g),divide(d,e))]).
%--------------------------------------------------------------------------
