%--------------------------------------------------------------------------
% File     : HEN011=OpComm-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : This operation is commutative
% Version  : [McCharen, et al., 1976] axioms.
% English  : Define & on the set of Z', where Z' = identity/Z, 
%            by X' & Y'=X'/(identity/Y'). The operation is commutative.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : HP11 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   20 (   0 non-Horn)(  11 unit)
%            Number of literals          :   33 (  21 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    9 (   8 constant)
%            Number of variables         :   31 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms for equality formulation 
include('Axioms/HEN002-0.ax').
include('Axioms/HEN002-0.eq').
%--------------------------------------------------------------------------
input_clause(part_of_theorem,hypothesis,
    [--equal(divide(divide(identity,a),divide(identity,
divide(identity,b))),divide(divide(identity,b),divide(identity,
divide(identity,a))))]).

input_clause(identity_divide_a,hypothesis,
    [++equal(divide(identity,a),c)]).

input_clause(identity_divide_b,hypothesis,
    [++equal(divide(identity,b),d)]).

input_clause(identity_divide_c,hypothesis,
    [++equal(divide(identity,c),e)]).

input_clause(identity_divide_d,hypothesis,
    [++equal(divide(identity,d),g)]).

input_clause(prove_commutativity,theorem,
    [--equal(divide(c,g),divide(d,e))]).
%--------------------------------------------------------------------------
