%--------------------------------------------------------------------------
% File     : HEN011=OpComm-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : This operation is commutative
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : Define & on the set of Z', where Z' = identity/Z, 
%            by X' & Y' = X'/(identity/Y'). The operation is commutative.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : H11 [McCharen, et al., 1976]
%          : hp11.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   36 (   0 non-Horn)(  15 unit)
%            Number of literals          :   80 (  20 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (  10 constant)
%            Number of variables         :   85 (   7 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms 
include('Axioms/HEN001-0.ax').
%----Include Henkin model equality axioms 
include('Axioms/HEN001-0.eq').
%--------------------------------------------------------------------------
%----McCharen uses these earlier results too. I don't 
input_clause(everything_divide_identity_is_zero,axiom,
    [++quotient(X,identity,zero)]).

input_clause(zero_divide_anything_is_zero,axiom,
    [++quotient(zero,X,zero)]).

input_clause(x_divide_x_is_zero,axiom,
    [++quotient(X,X,zero)]).

input_clause(x_divde_zero_is_x,axiom,
    [++quotient(X,zero,X)]).

input_clause(transitivity_of_less_equal,axiom,
    [--less_equal(X,Y),
     --less_equal(Y,Z),
     ++less_equal(X,Z)]).

input_clause(xQyLEz_implies_xQzLEy,axiom,
    [--quotient(X,Y,W1),
     --less_equal(W1,Z),
     --quotient(X,Z,W2),
     ++less_equal(W2,Y)]).

input_clause(xLEy_implies_zQyLEzQx,axiom,
    [--less_equal(X,Y),
     --quotient(Z,Y,W1),
     --quotient(Z,X,W2),
     ++less_equal(W1,W2)]).

input_clause(xLEy_implies_xQzLEyQz,axiom,
    [--less_equal(X,Y),
     --quotient(X,Z,W1),
     --quotient(Y,Z,W2),
     ++less_equal(W1,W2)]).

input_clause(one_inversion_equals_three,axiom,
    [--quotient(identity,X,Y1),
     --quotient(identity,Y1,Y2),
     --quotient(identity,Y2,Y3),
     ++equal(Y1,Y3)]).

input_clause(inversion_lemma,axiom,
    [--quotient(identity,X,Y1),
     --quotient(identity,Y1,Y2),
     --quotient(Y1,Y2,Y3),
     ++equal(Y1,Y3)]).

input_clause(identity_divide_a,hypothesis,
    [++quotient(identity,a,idQa)]).

input_clause(identity_divide_b,hypothesis,
    [++quotient(identity,b,idQb)]).

input_clause(identity_divide_idQb,hypothesis,
    [++quotient(identity,idQb,idQ_idQb)]).

input_clause(idQa_divide_idQ_idQb,hypothesis,
    [++quotient(idQa,idQ_idQb,idQa_Q__idQ_idQb)]).

input_clause(identity_divide_idQa,hypothesis,
    [++quotient(identity,idQa,idQ_idQa)]).

input_clause(idQb_divide_idQ_idQa,hypothesis,
    [++quotient(idQb,idQ_idQa,idQb_Q__idQ_idQa)]).

input_clause(prove_idQa_Q__idQ_idQb_equals_idQb_Q__idQ_idQa,theorem,
    [--equal(idQa_Q__idQ_idQb,idQb_Q__idQ_idQa)]).
%--------------------------------------------------------------------------
