%--------------------------------------------------------------------------
% File     : HEN011=OpComm-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : This operation is commutative
% Version  : [McCharen, et al., 1976] axioms.
% English  : Define & on the set of Z', where Z' = identity/Z, 
%            by X' & Y' = X'/(identity/Y'). The operation is commutative.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : H11 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   26 (   0 non-Horn)(  11 unit)
%            Number of literals          :   53 (  18 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (  10 constant)
%            Number of variables         :   55 (   3 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms 
include('Axioms/HEN001-0.ax').
%----Include Henkin model equality axioms 
include('Axioms/HEN001-0.eq').
%--------------------------------------------------------------------------
input_clause(identity_divide_a,hypothesis,
    [++quotient(identity,a,idQa)]).

input_clause(identity_divide_b,hypothesis,
    [++quotient(identity,b,idQb)]).

input_clause(identity_divide_idQb,hypothesis,
    [++quotient(identity,idQb,idQ_idQb)]).

input_clause(idQa_divide_idQ_idQb,hypothesis,
    [++quotient(idQa,idQ_idQb,idQa_Q__idQ_idQb)]).

input_clause(identity_divide_idQa,hypothesis,
    [++quotient(identity,idQa,idQ_idQa)]).

input_clause(idQb_divide_idQ_idQa,hypothesis,
    [++quotient(idQb,idQ_idQa,idQb_Q__idQ_idQa)]).

input_clause(prove_idQa_Q__idQ_idQb_equals_idQb_Q__idQ_idQa,theorem,
    [--equal(idQa_Q__idQ_idQb,idQb_Q__idQ_idQa)]).
%--------------------------------------------------------------------------
