%--------------------------------------------------------------------------
% File     : HEN010=IdDivX2-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : Define X' as identity/X. Then X' = X'/(identity/X')
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : H10 [McCharen, et al., 1976]
%          : hp10.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   23 (   0 non-Horn)(  11 unit)
%            Number of literals          :   39 (  21 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   44 (   5 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms for equality formulation 
include('Axioms/HEN002-0.ax').
include('Axioms/HEN002-0.eq').
%--------------------------------------------------------------------------
input_clause(everything_divide_id_is_zero,axiom,
    [++equal(divide(X,identity),zero)]).

input_clause(zero_divide_anything_is_zero,axiom,
    [++equal(divide(zero,X),zero)]).

input_clause(x_divide_x_is_zero,axiom,
    [++equal(divide(X,X),zero)]).

input_clause(x_divide_zero_is_x,axiom,
    [++equal(divide(a,zero),a)]).

input_clause(property_of_divide1,axiom,
    [--less_equal(divide(X,Y),Z),
     ++less_equal(divide(X,Z),Y)]).

input_clause(property_of_divide2,axiom,
    [--less_equal(X,Y),
     ++less_equal(divide(Z,Y),divide(Z,X))]).

input_clause(property_of_divide3,axiom,
    [--less_equal(X,Y),
     ++less_equal(divide(X,Z),divide(Y,Z))]).

input_clause(one_inversion_equals_three,axiom,
    [++equal(divide(identity,divide(identity,divide(identity,X))),
divide(identity,X))]).

input_clause(prove_property_of_inversion,theorem,
    [--equal(divide(identity,a),divide(divide(identity,a),
divide(identity,divide(identity,a))))]).
%--------------------------------------------------------------------------
