%--------------------------------------------------------------------------
% File     : HEN010=IdDivX2-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : Define X' as identity/X. Then X' = X'/(identity/X')
% Version  : [McCharen, et al., 1976] (equality) axioms :
%            Reduced & Augmented > Complete.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : H10 [McCharen, et al., 1976]
%          : hp10.ver3.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   18 (   0 non-Horn)(  10 unit)
%            Number of literals          :   29 (  29 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   6 constant)
%            Number of variables         :   30 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : less_equal replaced by divides
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms, for the equality formulation with 
%----less_equals removed.
include('Axioms/HEN003-0.ax').
%--------------------------------------------------------------------------
input_clause(transitivity_of_divide_to_zero,axiom,
    [--equal(divide(X,Y),zero),
     --equal(divide(Y,Z),zero),
     ++equal(divide(X,Z),zero)]).

input_clause(property_of_divide1,axiom,
    [--equal(divide(divide(X,Y),Z),zero),
     ++equal(divide(divide(X,Z),Y),zero)]).

input_clause(property_of_divide3,axiom,
    [--equal(divide(X,Y),zero),
     ++equal(divide(divide(X,Z),divide(Y,Z)),zero)]).

input_clause(part_of_theorem,hypothesis,
    [--equal(divide(identity,a),divide(divide(identity,a),
divide(identity,divide(identity,a))))]).

input_clause(identity_divide_a_is_b,hypothesis,
    [++equal(divide(identity,a),b)]).

input_clause(identity_divide_b_is_c,hypothesis,
    [++equal(divide(identity,b),c)]).

input_clause(b_divide_c_is_d,hypothesis,
    [++equal(divide(b,c),d)]).

input_clause(prove_inversion_property,theorem,
    [--equal(d,b)]).
%--------------------------------------------------------------------------
