%--------------------------------------------------------------------------
% File     : HEN009=IdDivX1-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : Define X' as identity/X. Then X' = X'''
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : H9 [McCharen, et al., 1976]
%          : hp9.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   24 (   0 non-Horn)(  13 unit)
%            Number of literals          :   39 (  23 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   6 constant)
%            Number of variables         :   40 (   5 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms for equality formulation 
include('Axioms/HEN002-0.ax').
include('Axioms/HEN002-0.eq').
%--------------------------------------------------------------------------
input_clause(everything_divide_id_is_zero,axiom,
    [++equal(divide(X,identity),zero)]).

input_clause(zero_divide_anything_is_zero,axiom,
    [++equal(divide(zero,X),zero)]).

input_clause(x_divide_x_is_zero,axiom,
    [++equal(divide(X,X),zero)]).

input_clause(property_of_divide1,axiom,
    [--less_equal(divide(X,Y),Z),
     ++less_equal(divide(X,Z),Y)]).

input_clause(property_of_divide3,axiom,
    [--less_equal(X,Y),
     ++less_equal(divide(X,Z),divide(Y,Z))]).

input_clause(part_of_theorem,hypothesis,
    [--equal(divide(identity,a),divide(identity,divide(identity,
divide(identity,a))))]).

input_clause(id_divide_a_is_b,hypothesis,
    [++equal(divide(identity,a),b)]).

input_clause(id_divide_b_is_c,hypothesis,
    [++equal(divide(identity,b),c)]).

input_clause(id_divide_c_is_d,hypothesis,
    [++equal(divide(identity,c),d)]).

input_clause(prove_b_equals_d,theorem,
    [--equal(b,d)]).
%--------------------------------------------------------------------------
