%--------------------------------------------------------------------------
% File     : HEN009=IdDivX1-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : Define X' as identity/X. Then X' = X'''
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : HP9 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   19 (   0 non-Horn)(  10 unit)
%            Number of literals          :   32 (  20 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   6 constant)
%            Number of variables         :   31 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms for equality formulation 
include('Axioms/HEN002-0.ax').
include('Axioms/HEN002-0.eq').
%--------------------------------------------------------------------------
input_clause(part_of_theorem,hypothesis,
    [--equal(divide(identity,a),divide(identity,divide(identity,
divide(identity,a))))]).

input_clause(id_divide_a_is_b,hypothesis,
    [++equal(divide(identity,a),b)]).

input_clause(id_divide_b_is_c,hypothesis,
    [++equal(divide(identity,b),c)]).

input_clause(id_divide_c_is_d,hypothesis,
    [++equal(divide(identity,c),d)]).

input_clause(prove_b_equals_d,theorem,
    [--equal(b,d)]).
%--------------------------------------------------------------------------
