%--------------------------------------------------------------------------
% File     : HEN009=IdDivX1-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : Define X' as identity/X. Then X' = X'''
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : H9 [McCharen, et al., 1976]
%          : hp9.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   31 (   0 non-Horn)(  12 unit)
%            Number of literals          :   69 (  18 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    7 (   6 constant)
%            Number of variables         :   77 (   5 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms 
include('Axioms/HEN001-0.ax').
%----Include Henkin model equality axioms 
include('Axioms/HEN001-0.eq').
%--------------------------------------------------------------------------
%----McCharen uses these earlier results too. I don't 
input_clause(everything_divide_identity_is_zero,axiom,
    [++quotient(X,identity,zero)]).

input_clause(zero_divide_anything_is_zero,axiom,
    [++quotient(zero,X,zero)]).

input_clause(x_divide_x_is_zero,axiom,
    [++quotient(X,X,zero)]).

input_clause(x_divde_zero_is_x,axiom,
    [++quotient(X,zero,X)]).

input_clause(transitivity_of_less_equal,axiom,
    [--less_equal(X,Y),
     --less_equal(Y,Z),
     ++less_equal(X,Z)]).

input_clause(xQyLEz_implies_xQzLEy,axiom,
    [--quotient(X,Y,W1),
     --less_equal(W1,Z),
     --quotient(X,Z,W2),
     ++less_equal(W2,Y)]).

input_clause(xLEy_implies_zQyLEzQx,axiom,
    [--less_equal(X,Y),
     --quotient(Z,Y,W1),
     --quotient(Z,X,W2),
     ++less_equal(W1,W2)]).

input_clause(xLEy_implies_xQzLEyQz,axiom,
    [--less_equal(X,Y),
     --quotient(X,Z,W1),
     --quotient(Y,Z,W2),
     ++less_equal(W1,W2)]).

input_clause(identity_divide_a,hypothesis,
    [++quotient(identity,a,idQa)]).

input_clause(identity_divide_idQa,hypothesis,
    [++quotient(identity,idQa,idQ_idQa)]).

input_clause(identity_divide_idQ_idQa,hypothesis,
    [++quotient(identity,idQ_idQa,idQ__idQ_idQa)]).

input_clause(prove_one_inversion_equals_three,theorem,
    [--equal(idQa,idQ__idQ_idQa)]).
%--------------------------------------------------------------------------
