%--------------------------------------------------------------------------
% File     : HEN009=IdDivX1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : Define X' as identity/X. Then X' = X'''
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : H9 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   23 (   0 non-Horn)(   8 unit)
%            Number of literals          :   50 (  18 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    7 (   6 constant)
%            Number of variables         :   55 (   3 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms 
include('Axioms/HEN001-0.ax').
%----Include Henkin model equality axioms 
include('Axioms/HEN001-0.eq').
%--------------------------------------------------------------------------
input_clause(identity_divide_a,hypothesis,
    [++quotient(identity,a,idQa)]).

input_clause(identity_divide_idQa,hypothesis,
    [++quotient(identity,idQa,idQ_idQa)]).

input_clause(identity_divide_idQ_idQa,hypothesis,
    [++quotient(identity,idQ_idQa,idQ__idQ_idQa)]).

input_clause(prove_one_inversion_equals_three,theorem,
    [--equal(idQa,idQ__idQ_idQa)]).
%--------------------------------------------------------------------------
