%--------------------------------------------------------------------------
% File     : HEN008=Eqn3-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : X <= Y => X/Z <= Y/Z
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : H8 [McCharen, et al., 1976]
%          : hp8.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   19 (   0 non-Horn)(  10 unit)
%            Number of literals          :   32 (  18 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    6 (   5 constant)
%            Number of variables         :   34 (   5 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms for equality formulation 
include('Axioms/HEN002-0.ax').
include('Axioms/HEN002-0.eq').
%--------------------------------------------------------------------------
input_clause(everything_divide_id_is_zero,axiom,
    [++equal(divide(X,identity),zero)]).

input_clause(zero_divide_anything_is_zero,axiom,
    [++equal(divide(zero,X),zero)]).

input_clause(x_divide_x_is_zero,axiom,
    [++equal(divide(X,X),zero)]).

input_clause(a_LE_b,hypothesis,
    [++less_equal(a,b)]).

input_clause(prove_a_divide_c_LE_b_divide_c,theorem,
    [--less_equal(divide(a,c),divide(b,c))]).
%--------------------------------------------------------------------------
