%--------------------------------------------------------------------------
% File     : HEN007=Eqn2-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : X <= Y => Z/Y <= Z/X
% Version  : [McCharen, et al., 1976] (equality) axioms :
%            Reduced & Augmented > Complete.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : H7 [McCharen, et al., 1976]
%          : hp7.ver3.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   13 (   0 non-Horn)(   7 unit)
%            Number of literals          :   22 (  22 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   5 constant)
%            Number of variables         :   24 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : less_equal replaced by divides
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms, for the equality formulation with 
%----less_equals removed.
include('Axioms/HEN003-0.ax').
%--------------------------------------------------------------------------
input_clause(transitivity_of_divide_to_zero,axiom,
    [--equal(divide(X,Y),zero),
     --equal(divide(Y,Z),zero),
     ++equal(divide(X,Z),zero)]).

input_clause(a_divide_b_is_zero,hypothesis,
    [++equal(divide(a,b),zero)]).

input_clause(prove_property_of_divide2,theorem,
    [--equal(divide(divide(c,b),divide(c,a)),zero)]).
%--------------------------------------------------------------------------
