%--------------------------------------------------------------------------
% File     : HEN007=Eqn2-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : X <= Y => Z/Y <= Z/X
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : H7 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   29 (   0 non-Horn)(  12 unit)
%            Number of literals          :   61 (  17 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   7 constant)
%            Number of variables         :   67 (   5 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms 
include('Axioms/HEN001-0.ax').
%----Include Henkin model equality axioms 
include('Axioms/HEN001-0.eq').
%--------------------------------------------------------------------------
%----McCharen uses these earlier results too. I don't 
input_clause(everything_divide_identity_is_zero,axiom,
    [++quotient(X,identity,zero)]).

input_clause(zero_divide_anything_is_zero,axiom,
    [++quotient(zero,X,zero)]).

input_clause(x_divide_x_is_zero,axiom,
    [++quotient(X,X,zero)]).

input_clause(x_divde_zero_is_x,axiom,
    [++quotient(X,zero,X)]).

input_clause(transitivity_of_less_equal,axiom,
    [--less_equal(X,Y),
     --less_equal(Y,Z),
     ++less_equal(X,Z)]).

input_clause(xQyLEz_implies_xQzLEy,axiom,
    [--quotient(X,Y,W1),
     --less_equal(W1,Z),
     --quotient(X,Z,W2),
     ++less_equal(W2,Y)]).

input_clause(xLEy,hypothesis,
    [++less_equal(x,y)]).

input_clause(zQy,hypothesis,
    [++quotient(z,y,zQy)]).

input_clause(zQx,hypothesis,
    [++quotient(z,x,zQx)]).

input_clause(prove_zQyLEzQx,theorem,
    [--less_equal(zQy,zQx)]).
%--------------------------------------------------------------------------
