%--------------------------------------------------------------------------
% File     : HEN007=Eqn2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : X <= Y => Z/Y <= Z/X
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : H7 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   23 (   0 non-Horn)(   8 unit)
%            Number of literals          :   50 (  17 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   7 constant)
%            Number of variables         :   55 (   3 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms 
include('Axioms/HEN001-0.ax').
%----Include Henkin model equality axioms 
include('Axioms/HEN001-0.eq').
%--------------------------------------------------------------------------
input_clause(xLEy,hypothesis,
    [++less_equal(x,y)]).

input_clause(zQy,hypothesis,
    [++quotient(z,y,zQy)]).

input_clause(zQx,hypothesis,
    [++quotient(z,x,zQx)]).

input_clause(prove_zQyLEzQx,theorem,
    [--less_equal(zQy,zQx)]).
%--------------------------------------------------------------------------
