%--------------------------------------------------------------------------
% File     : HEN006=Eqn1-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : X/Y <= Z => X/Z <= Y
% Version  : [McCharen, et al., 1976] (equality) axioms :
%            Reduced & Augmented > Complete.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : H6 [McCharen, et al., 1976]
%          : hp6.ver3.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   13 (   0 non-Horn)(   8 unit)
%            Number of literals          :   20 (  20 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   5 constant)
%            Number of variables         :   22 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : less_equal replaced by divides.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms, for the equality formulation with 
%----less_equals removed.
include('Axioms/HEN003-0.ax').
%--------------------------------------------------------------------------
input_clause(x_divide_zero_is_x,axiom,
    [++equal(divide(X,zero),X)]).

input_clause(a_divide_b_divide_d_is_zero,hypothesis,
    [++equal(divide(divide(a,b),d),zero)]).

input_clause(prove_property_of_divide1,theorem,
    [--equal(divide(divide(a,d),b),zero)]).
%--------------------------------------------------------------------------
