%--------------------------------------------------------------------------
% File     : HEN005=LeTrans-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : The relation less_equal is transitive
% Version  : [McCharen, et al., 1976] (equality) axioms :
%            Reduced & Augmented > Complete.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : H5 [McCharen, et al., 1976]
%          : hp5.ver3.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   13 (   0 non-Horn)(   8 unit)
%            Number of literals          :   20 (  20 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   5 constant)
%            Number of variables         :   21 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms, for the equality formulation with 
%----less_equals removed.
include('Axioms/HEN003-0.ax').
%--------------------------------------------------------------------------
input_clause(a_divide_b_is_zero,hypothesis,
    [++equal(divide(a,b),zero)]).

input_clause(b_divide_c_is_zero,hypothesis,
    [++equal(divide(b,c),zero)]).

input_clause(prove_transitivity_of_divide_to_zero,theorem,
    [--equal(divide(a,c),zero)]).
%--------------------------------------------------------------------------
