%--------------------------------------------------------------------------
% File     : HEN005=LeTrans-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : The relation less_equal is transitive
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : HP5 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   17 (   0 non-Horn)(   8 unit)
%            Number of literals          :   30 (  15 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    6 (   5 constant)
%            Number of variables         :   31 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms for equality formulation 
include('Axioms/HEN002-0.ax').
include('Axioms/HEN002-0.eq').
%--------------------------------------------------------------------------
input_clause(a_LE_b,hypothesis,
    [++less_equal(a,b)]).

input_clause(b_LE_c,hypothesis,
    [++less_equal(b,c)]).

input_clause(prove_a_LE_c,theorem,
    [--less_equal(a,c)]).
%--------------------------------------------------------------------------
